<?php

/**
 * I am THE file that defines the {{generator_name}} installation functionalities
 * I extend Glb_Plugin_Installer, and take profit of all it's functionalities
 *
 * This file is distributed under the same license as the {{generator_package}} package.
 *
 * @since             {{generator_version}}
 * @link              {{generator_link}}
 * @author            {{generator_author}}
 * @package           {{generator_package}}
 */
class Glb_{{generator_sname_wc_u}}_Installer extends Glb_Plugin_Installer {

    /**
     * When the plugin is activated
     */
    public function activate() {
        Glb_Log::notice('{{generator_sname_wc_u}} activated');<<GENERATOR_DATABASE
        $this->install_database();GENERATOR_DATABASE>><<GENERATOR_ROLES
        $this->install_roles();GENERATOR_ROLES>>
        // parent activation needs to be called at the end !
        parent::activate();
    }

    /**
     * When the plugin is deactivated
     */
    public function deactivate() {
        parent::deactivate();
    }

    /**
     * When the plugin is uninstalled
     */
    public function uninstall() {<<GENERATOR_DATABASE
        $this->uninstall_database();GENERATOR_DATABASE>><<GENERATOR_ROLES
        $this->uninstall_roles();GENERATOR_ROLES>>
        parent::uninstall();
    }
    <<GENERATOR_ROLES
    /**
     * Uninstall roles
     */
    protected function uninstall_roles()
    {
        remove_role( 'glb_{{generator_sname_lc_u}}_user' );
        remove_role( 'glb_{{generator_sname_lc_u}}_admin' );
    }

    /**
     * Install roles
     */
    protected function install_roles() {
        $result = add_role(
            'glb_{{generator_sname_lc_u}}_user',
            __glb('Gloubi %s User', '{{generator_sname}}'),
            array(
                'read' => true,
                'glb_{{generator_sname_lc_u}}_access' => true,
                'glb_{{generator_sname_lc_u}}_admin' => false,
                'edit_posts' => false,
                'delete_posts' => false,
            )
        );

        if (null === $result) {
            Glb_Db_Log::instance()->log('plugin_activate', 'engine', [__glbr('Unable to create role %s'), 'glb_{{generator_sname_lc_u}}_user'], null, 'error');
        }

        $result = add_role(
            'glb_{{generator_sname_lc_u}}_admin',
            __glb('Gloubi {{generator_sname}} Admin'),
            array(
                'read' => true,
                'glb_{{generator_sname_lc_u}}_access' => true,
                'glb_{{generator_sname_lc_u}}_admin' => true,
                'edit_posts' => false,
                'delete_posts' => false,
            )
        );

        if (null === $result) {
            Glb_Db_Log::instance()->log('plugin_activate', 'engine', [__glbr('Unable to create role %s'), 'glb_{{generator_sname_lc_u}}_admin'], null, 'error');
        }
    }
    GENERATOR_ROLES>>
    <<GENERATOR_DATABASE
    /**
     * Need to install a database ? You are at the right place...
     */
    protected function install_database() {

        // sql script to create database
        Glb_Db::instance()->create_table(
            'glb_{{generator_sname_lc_u}}_{{generator_main_use_plur_lc_u}}',
            "`id` int(11) unsigned NOT NULL AUTO_INCREMENT,
            `name` varchar(255) NOT NULL COMMENT 'Repository name',
            `description` varchar(255) DEFAULT NULL COMMENT 'A short description',
            `status` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Status : 0 = inactive, 1 = active',
            `created` datetime NULL DEFAULT NULL COMMENT 'Creation date',
            `modified` datetime NULL DEFAULT NULL COMMENT 'Modification date',
            PRIMARY KEY (`id`),
              KEY `i_name` (`name`(50))",
            "ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci"
        );

        // add data for demo
        for ($i = 1; $i < 200; $i++) {
            $time = date('Y-m-d H:i:s', strtotime('-' . (60*$i) .' minutes'));
            $fake = [
                'id' => $i,
                'name' => 'name ' . $i,
                'description' => 'description ' . $i,
                'status' => ($i % 3 == 0) ? 0 : 1,
                'created' => $time,
                'modified' => $time,
            ];
            Glb_Db::instance()->insert('glb_{{generator_sname_lc_u}}_{{generator_main_use_plur_lc_u}}', $fake);

        }

        $installed_ver = get_option('glb_{{generator_sname_lc_u}}_db_version', null);
        if ($installed_ver === null) {

            add_option('glb_{{generator_sname_lc_u}}_db_version', $this->plugin->version);

        } else if ($installed_ver != $this->plugin->version) {

            /*..........
            require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
            dbDelta($sql);
            */

            // notice that we are updating option, rather than adding it
            //update_option('custom_table_example_db_version', $custom_table_example_db_version);
        }

    }

    /**
     * Need to install a database ? You are at the right place...
     */
    protected function uninstall_database() {
        Glb_Db::instance()->drop_table("glb_{{generator_sname_lc_u}}_{{generator_main_use_plur_lc_u}}");
        delete_option( 'glb_{{generator_sname_lc_u}}_db_version' );
    }GENERATOR_DATABASE>>
}
